// Infračervený přijímač
// Spusť seriálový monitor, vezmi ovladač.
// Stiskni klávesu ON/OFF a podívej se na kód v monitoru. 
// My jsme používali ovladač od televize Philips, jeho ON/OFF kód je „0x4c“ a „0x84c“.
// Ovladač přidává "8" každé sudé zmáčknutí.
// Vyměň náš ON/OFF kód za svůj a znova nahraj kód do Arduino. 
// Když stiskneš klávesu ON / OFF, LED na Arduino se rozsvítí.
// Stiskni libovolnou jinou klávesu a LED zhasne.
// Email:laskarduino@gmail.com
// Web:laskarduino.cz
/*/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/*/

#include <IRremote.h>   

const int IRPin = 2;			// číslo pinu tlačítka přijímače
const int ledPin = 13;			// číslo pinu zabudované LEDky

IRrecv irrecv(IRPin);			// vytvoříme objekt typu IRrecv
decode_results results;			// definujeme proměnnou
 
void setup() {
	pinMode(ledPin,OUTPUT);		// nastavení pinu LEDky jako výstupu
	Serial.begin(9600);			// spustit sériový monitor na 9600 bps
	irrecv.enableIRIn();		// zapnout infračervený přijímač  
}
 
void loop() {
	if (irrecv.decode(&results)) {			// pokud přijímač přijal data
		Serial.print("IR Kod: ");         // tisknout "irCode: "
		Serial.print(results.value, HEX); // tisknout data jako hexdecimal
		Serial.print(",  bity: ");  	    // tisknout " ,  bity: "
		Serial.println(results.bits);  		// tisknout bity
		irrecv.resume();                  // přijata další data
	}  
	delay(600);  //počkat 600ms

  // 2 Kódy tlačitka "ON/OFF"
	if(results.value == 0x4c || results.value == 0x84c) {
		digitalWrite(ledPin,HIGH);        // zapnout LEDku
	} else {
		digitalWrite(ledPin,LOW);         // vypnout LEDku
	}
}
